
const pid = process.pid.toString(10);
const PID_PREFIX = pid.length > 4 ? pid.slice(-4) : pid.slice(-1 * pid.length);
const SEQ_LENGTH = 2;
const DATE_LENGTH = PID_PREFIX.length + SEQ_LENGTH + 1 - 9; // symbol_unique uses a 9 digit number
let uniq_sequence = Math.pow(10, SEQ_LENGTH);

/**
 * Return a unique symbol by matching the signature of symbol_unique
 * Combines the process ID with the current time, as well as an increasing integer
 */
module.exports.uniqID = () => {
	// Integer overflow, except wrap back to the smallest number guaranteed to have enough
	// nonzero leading digits
	if (uniq_sequence >= Number.MAX_SAFE_INTEGER) uniq_sequence = Math.pow(10, SEQ_LENGTH);
	return `u${PID_PREFIX}${Date.now().toString(10).slice(DATE_LENGTH)}${(uniq_sequence++).toString(10).slice(-SEQ_LENGTH)}`;
};

module.exports.enhanceServerWithDestroy = (server) => {
	const connections = new Map();

	server.on("connection", (conn) => {
		const key = [conn.remoteAddress, conn.remotePort].join(":");
		connections.set(key, conn);
		conn.on("close", () => {
			connections.delete(key);
		});
	});

	server.destroy = (cb) => {
		return new Promise((resolve, reject) => {
			server.close((err) => {
				if (err) return reject(err);
				return resolve();
			});

			connections.forEach((conn, id) => {
				conn.end();
			});
		});
	};
};

module.exports.sleep = (t) => {
	return new Promise(resolve => {
		setTimeout(resolve, t || 0);
	});
};
